<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Catalogo de Productos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
</head>

<body>

    <header>
        <div class="collapse bg-dark" id="navbarHeader">
            <div class="container">
                <div class="row">
                    <div class="col-sm-8 col-md-7 py-4">
                        <h4 class="text-white">About</h4>
                        <p class="text-muted">Add some information about the album below, the author, or any other background context. Make it a few sentences long so folks can pick up some informative tidbits. Then, link them off to some social networking sites or contact information.</p>
                    </div>
                    <div class="col-sm-4 offset-md-1 py-4">
                        <h4 class="text-white">Contact</h4>
                        <ul class="list-unstyled">
                            <li><a href="#" class="text-white">Follow on Twitter</a></li>
                            <li><a href="#" class="text-white">Like on Facebook</a></li>
                            <li><a href="#" class="text-white">Email me</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="navbar navbar-dark bg-dark shadow-sm">
            <div class="container">
                <a href="#" class="navbar-brand d-flex align-items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" aria-hidden="true" class="me-2" viewBox="0 0 24 24">
                        <path d="M23 19a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h4l2-3h6l2 3h4a2 2 0 0 1 2 2z"></path>
                        <circle cx="12" cy="13" r="4"></circle>
                    </svg>
                    <strong>Catalogos</strong>
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarHeader" aria-controls="navbarHeader" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </div>
        </div>
    </header>

    <main>

        <section class="py-1 text-center container">
            <div class="row py-lg-2">
                <div class="col-lg-6 col-md-8 mx-auto">
                    <h1 class="fw-light">Catalogo de Proveedores</h1>
                    <p class="lead text-muted">En este catlogo de proveedores se podra visalizar la informacion de cada miembro asi como sus productos.</p>
                    <p>
                        <a href="#" class="btn btn-primary my-2" data-bs-toggle="modal" data-bs-target="#formularioModal">Añadir Proveedor</a>
                        <a href="#" class="btn btn-secondary my-2">Añadir Producto</a>
                    </p>
                </div>
            </div>
        </section>

        <div class="album py-5 bg-light">
            <div class="container">
                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 g-3">
                    <?php
                    $inc = include("db.php");
                    if ($inc) {
                        $consulta = "SELECT * FROM proveedores";
                        $resultado = mysqli_query($conn, $consulta);
                        if ($resultado) {
                            while ($row = $resultado->fetch_array()) {
                                $id = $row["id"];
                                $nombre = $row["nombre"];
                                $direccion = $row["direccion"];
                                $email = $row["email"];
                                $telefono = $row["telefono"];
                                $foto = $row["foto"];
                    ?>
                                <div class="col">
                                    <div class="card shadow-sm">
                                        <div style="margin-top: 5px;">
                                            <img class="mx-auto d-block bd-placeholder-img rounded-circle" style="width: 150px" src="<?php echo $foto ?>">
                                        </div>
                                        <div class="card-body">
                                            <h3 class="card-title"><a class="text-secondary"><?php echo $nombre ?></a></h3>
                                            <p class="card-text">Dirección: <?php echo  $direccion ?></p>
                                            <p class="card-text">Telefono: <?php echo  $telefono ?></p>
                                            <p class="card-text">Email: <?php echo  $email ?></p>
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div class="btn-group">
                                                    <button type="button" onclick="showHint(<?php echo  $id ?>);" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModal">Ver Productos</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                    <?php
                            }
                        }
                    }
                    ?>
                </div>
            </div>
        </div>

        <script>
            function showHint(str) {
                if (str.length == 0) {
                    document.getElementById("txtHint").innerHTML = "";
                    return;
                } else {
                    var xmlhttp = new XMLHttpRequest();
                    xmlhttp.onreadystatechange = function() {
                        if (this.readyState == 4 && this.status == 200) {
                            document.getElementById("txtHint").innerHTML = this.responseText;
                            document.getElementById("id-proveedor").value = str;
                        }
                    }
                    xmlhttp.open("GET", "catalogo-productos.php?q=" + str, true);
                    xmlhttp.send();
                }
            }

            function producto(str) {
                let id = document.getElementById("id-proveedor").value;
                let nombre = document.getElementById("nombre-producto").value;
                let descripcion = document.getElementById("descripcion-producto").value;
                let precio = document.getElementById("precio-producto").value;
                let cantidad = document.getElementById("cantidad-producto").value;
                let input = document.getElementById("foto-producto");


                var data = new FormData();
                data.append('proveedor_id', id);
                data.append('nombre', nombre);
                data.append('descripcion', descripcion);
                data.append('precio', precio);
                data.append('cantidad', cantidad);
                data.append('foto', input.files[0]);
                if (nombre.length == 0) {
                    alert("Faltan espacios por llenar")
                } else {
                    var xmlhttp1 = new XMLHttpRequest();
                    xmlhttp1.onreadystatechange = function() {
                        if (this.readyState == 4 && this.status == 200) {
                            alert("Producto Guardado correctamente");
                        }
                    }

                    xmlhttp1.open("POST", "incertar-producto.php", true);
                    xmlhttp1.onload = function() {
                        // do something to response
                        console.log(this.responseText);
                    };
                    xmlhttp1.send(data);
                }
            }
        </script>

        <div class="modal fade bd-example-modal-xl" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Catalogo de Productos</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="image-libro">
                        <div class="album py-5 bg-light">
                            <div class="container">
                                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 g-3">
                                    <span id="txtHint"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#formularioProductoModal">Agregar Producto</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="formularioModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Nuevo Proveedor</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="incertar-proveedor.php" method="post" enctype="multipart/form-data">
                            <div class="form-group" >
                                <label for="recipient-name" class="col-form-label">Nombre:</label>
                                <input type="text" class="form-control" name="nombre" id="recipient-name">
                            </div>
                            <div class="form-group">
                                <label for="message-text" class="col-form-label">Email:</label>
                                <input type="text" class="form-control" name="email" id="message-text"></input>
                            </div>
                            <div class="form-group">
                                <label for="message-text" class="col-form-label">Telefono:</label>
                                <input type="number" class="form-control" name="telefono" id="message-text"></input>
                            </div> 
                            <div class="form-group">
                                <label for="message-text" class="col-form-label">Dirección:</label>
                                <input type="text" class="form-control" name="direccion" id="message-text"></input>
                            </div>
                            <div class="form-group">
                                <label for="message-text" class="col-form-label">Foto:</label>
                                <input type="file" class="form-control" name="fileToUpload" id="fileToUpload"></input>
                            </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="modal fade" id="formularioProductoModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Nuevo Proveedor</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form name="form-producto" action="incertar-producto.php" method="post">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">id-proveedor:</label>
                                <input type="text" class="form-control" name="id-proveedor">
                            </div>
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Nombre:</label>
                                <input type="text" class="form-control" name="nombre-producto">
                            </div>
                            <div class="form-group">
                                <label for="message-text" class="col-form-label">Descripción:</label>
                                <input type="text" class="form-control" name="descripcion-producto"></input>
                            </div>
                            <div class="form-group">
                                <label for="message-text" class="col-form-label">Precio:</label>
                                <input type="number" class="form-control" name="precio-producto"></input>
                            </div>
                            <div class="form-group">
                                <label for="message-text" class="col-form-label">Cantidad:</label>
                                <input type="number" class="form-control" name="cantidad-producto"></input>
                            </div>
                            <div class="form-group">
                                <label for="message-text" class="col-form-label">Foto:</label>
                                <input type="file" name="fileToUpload" class="form-control" id="foto-producto"></input>
                            </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </main>

    <footer class="text-muted py-5">
        <div class="container">
            <p class="float-end mb-1">
                <a href="#">Back to top</a>
            </p>
            <p class="mb-1">Album example is © Bootstrap, but please download and customize it for yourself!</p>
            <p class="mb-0">New to Bootstrap? <a href="/">Visit the homepage</a> or read our <a href="/docs/5.0/getting-started/introduction/">getting started guide</a>.</p>
        </div>
    </footer>


    <script src="/docs/5.0/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>




</body>